<?php
/**
 * Plugin Name: کارامانا - غیرفعال‌کننده نظرات وردپرس
 * Plugin URI: https://karamana.ir/plugins/disable_wp_comments
 * Description: این افزونه به طور کامل سیستم نظرات وردپرس را غیرفعال می‌کند - تولید شده با عشق در کارامانا
 * Version: 1.0.1
 * Author: هادی رفیعی
 * License: GPL v2 or later
 */

// جلوگیری از دسترسی مستقیم
if (!defined('ABSPATH')) {
    exit;
}

// غیرفعال کردن نظرات در کل سایت
class WP_Comment_Disabler {
    
    public function __construct() {
        // غیرفعال کردن نظرات در تنظیمات بحث
        add_filter('comments_open', array($this, 'disable_comments'), 20, 2);
        add_filter('pings_open', array($this, 'disable_comments'), 20, 2);
        
        // مخفی کردن بخش نظرات موجود
        add_filter('comments_array', array($this, 'hide_existing_comments'), 10, 2);
        
        // غیرفعال کردن فید نظرات
        add_filter('feed_links_show_comments_feed', '__return_false');
        
        // حذف منوی نظرات از ادمین بار
        add_action('wp_before_admin_bar_render', array($this, 'remove_admin_bar_comments'));
        
        // حذف صفحه نظرات از پیشخوان
        add_action('admin_menu', array($this, 'remove_comments_admin_menu'));
        
        // تغییر ستون‌های پست‌ها
        add_filter('manage_posts_columns', array($this, 'remove_comments_column'));
        add_filter('manage_pages_columns', array($this, 'remove_comments_column'));
        
        // غیرفعال کردن نظرات در ویرایشگر بلوک
        add_action('init', array($this, 'disable_block_editor_comments'));
        
        // حذف بحث از تنظیمات نوشتن
        add_action('admin_init', array($this, 'remove_comment_support'));
        
        // تغییر مسیر درخواست‌های نظرات
        add_action('template_redirect', array($this, 'redirect_comment_pages'));
    }
    
    // غیرفعال کردن نظرات جدید
    public function disable_comments($open, $post_id) {
        return false;
    }
    
    // مخفی کردن نظرات موجود
    public function hide_existing_comments($comments) {
        return array();
    }
    
    // حذف منوی نظرات از ادمین بار
    public function remove_admin_bar_comments() {
        global $wp_admin_bar;
        $wp_admin_bar->remove_menu('comments');
    }
    
    // حذف صفحه نظرات از پیشخوان
    public function remove_comments_admin_menu() {
        remove_menu_page('edit-comments.php');
        remove_submenu_page('options-general.php', 'options-discussion.php');
        
        // حذف متا باکس نظرات از ویرایشگر پست
        remove_meta_box('commentsdiv', 'post', 'normal');
        remove_meta_box('commentstatusdiv', 'post', 'normal');
        remove_meta_box('trackbacksdiv', 'post', 'normal');
    }
    
    // حذف ستون نظرات از لیست پست‌ها
    public function remove_comments_column($columns) {
        unset($columns['comments']);
        return $columns;
    }
    
    // غیرفعال کردن نظرات در ویرایشگر بلوک
    public function disable_block_editor_comments() {
        // حذف پشتیبانی نظرات از انواع پست‌ها
        remove_post_type_support('post', 'comments');
        remove_post_type_support('page', 'comments');
        
        // برای سایر انواع پست‌های سفارشی
        $post_types = get_post_types();
        foreach ($post_types as $post_type) {
            remove_post_type_support($post_type, 'comments');
            remove_post_type_support($post_type, 'trackbacks');
        }
    }
    
    // حذف پشتیبانی نظرات از همه پست‌ها
    public function remove_comment_support() {
        update_option('default_comment_status', 'closed');
        update_option('close_comments_for_old_posts', true);
        update_option('close_comments_days_old', 0);
        update_option('comment_registration', true);
        update_option('comments_notify', false);
        update_option('moderation_notify', false);
        update_option('comment_whitelist', false);
        update_option('show_avatars', false);
    }
    
    // ریدایرکت صفحات مرتبط با نظرات
    public function redirect_comment_pages() {
        if (is_singular() && (isset($_GET['replytocom']) || strpos($_SERVER['REQUEST_URI'], 'comment-page-') !== false)) {
            wp_redirect(get_permalink());
            exit;
        }
    }
}

// راه‌اندازی افزونه
new WP_Comment_Disabler();

// غیرفعال کردن REST API نظرات
add_filter('rest_endpoints', function($endpoints) {
    unset($endpoints['/wp/v2/comments']);
    unset($endpoints['/wp/v2/comments/(?P<id>[\d]+)']);
    return $endpoints;
});

// غیرفعال کردن فید نظرات
function disable_comment_feeds($for_comments) {
    if ($for_comments) {
        wp_die('فید نظرات غیرفعال شده است.', 'فید نظرات غیرفعال', array('response' => 403));
    }
}
add_action('do_feed_rss2', 'disable_comment_feeds', 9);
add_action('do_feed_atom', 'disable_comment_feeds', 9);